jQuery(function($) {

	// Toggle quote products
	$(document.body).on('click', '.wccsq-shipping-quote-items', function() {
		$(this).parents('tr').first().find('.wccsq-products-table').toggle();
	});

	// Toggle quote amount field
	$(document.body).on('click', '.edit-quoted-amount', function() {
		$(this).parent().find('.quoted-amount-price, .save-quoted-amount, .cancel-quoted-amount, .edit-quoted-amount').toggle();
		$(this).parent().find('.quote_amount').toggle().select();
	});

	// Save
	$(document.body).on('click', '.save-quoted-amount', function(e) {
		$(this).parents('form').submit();
	});

	// Cancel
	$(document.body).on('click', '.cancel-quoted-amount', function(e) {
		$(this).parent().find('.quote_amount, .quoted-amount-price, .save-quoted-amount, .cancel-quoted-amount, .edit-quoted-amount').toggle();
	});

	$(document.body).on('submit', 'form.shipping-quote-actions', function(e) {
		e.preventDefault();

		var data = $(this).serialize() + '&' + $.param({ nonce: wccsq.nonce, action: 'wccsq_shipping_quote_action' });

		var $this = $(this),
			row = $this.parents('tr').first(),
			topOffset = ($this.parents('td').outerHeight() - $this.height()) / 2,
			leftOffset = $this.parents('td')[0].getBoundingClientRect().left - $this.parents('tr')[0].getBoundingClientRect().left + 13;

		$this.block({ message: null, overlayCSS: { background: '#fff', opacity: 0.6, top: -topOffset, left: -leftOffset, width: row.width(), height: row.height() } });
		$.post(ajaxurl, data, function(response) {

			if (response.success) {
				if (response.html == null) {
					row.remove();
				} else {
					row.replaceWith(response.html);
					$this.unblock();
				}
			}
		});
	});

});
